import net from 'net';
import mysql from 'mysql2/promise';

const pool = mysql.createPool({
  host: '184.168.120.17',
  user: 'sjps_fibre_2025',
  password: 'OApZq%Zyom_^',
  database: 'sjps_fibre_2025',
  port: 3306,
  waitForConnections: true,
  connectionLimit: 1000,
  queueLimit: 0
});

// List of patterns to ignore
const IGNORE_PATTERNS = [
  'build:',
  '�',
  "build:"
];

// Function to safely handle database operations
async function insertEPC(epc) {
  let connection;
  try {
    connection = await pool.getConnection();
    await connection.execute(
      'INSERT INTO `s_epc_data`(`epc`, `inout_datetime`, `unit_id`) VALUES(?, ?, ?)',
      [epc, new Date(), '2']
    );
    console.log(`Inserted EPC: ${epc}`);
  } catch (error) {
    console.error('Database error:', error.message);
  } finally {
    if (connection) connection.release();
  }
}

const server = net.createServer((socket) => {
  let buffer = '';
  
  console.log('RFID Reader Connected:', socket.remoteAddress);

  socket.on('data', async (data) => {
    try {
      buffer += data.toString();
      
      let startIdx = buffer.indexOf('@');
      while (startIdx !== -1) {
        const endIdx = buffer.indexOf('$', startIdx);
        
        if (endIdx === -1) break;
        
        const fullTag = buffer.substring(startIdx, endIdx + 1);
        const epc = fullTag.slice(1, -1);
        
        const shouldIgnore = IGNORE_PATTERNS.some(pattern => 
          fullTag.includes(pattern) || epc.includes(pattern)
        );
        
        if (!shouldIgnore && epc.length > 0) {
          console.log('Processing EPC:', epc);
          await insertEPC(epc); // Using our safe insert function
        } else {
          console.log('Ignored system message:', fullTag);
        }
        
        buffer = buffer.substring(endIdx + 1);
        startIdx = buffer.indexOf('@');
      }
      
      if (buffer.length > 1024) {
        console.warn('Buffer overflow, clearing');
        buffer = '';
      }
    } catch (error) {
      console.error('Error processing data:', error);
    }
  });

  socket.on('error', (err) => {
    console.error('RFID Reader Error:', err);
  });

  socket.on('end', () => {
    console.log('RFID Reader Disconnected');
  });
});

// Graceful shutdown handler
async function shutdown() {
  console.log('Shutting down servers...');
  try {
    server.close();
    await pool.end();
    console.log('Servers closed gracefully');
    process.exit(0);
  } catch (err) {
    console.error('Error during shutdown:', err);
    process.exit(1);
  }
}

process.on('SIGTERM', shutdown);
process.on('SIGINT', shutdown);

server.listen(21173, () => {
  console.log('TCP Server listening on port 21604');
});